﻿//////////////////////////////////////////////
// TextureExternalData.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Renderers/RenderingApi.h"

#include "../Textures/Enums/TextureRenderFlag.h"

/// Enums ------------------------------------

namespace nkGraphics
{
	enum class RESOURCE_STATE
	{
		COMMON = 0,
		RENDER_TARGET,
		DEPTH_TARGET
	} ;
}

/// Class ------------------------------------
	
namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT TextureExternalData final
	{		
		public :
		
			// Destructor
			~TextureExternalData () ;

			// Getters
			void* getResource () const ;
			RESOURCE_STATE getState () const ;
			unsigned int getId () const ;
			TEXTURE_RENDER_FLAG getRenderFlag () const ;
			RENDERING_API getTargetApi () const ;
			bool getGammaCorrect () const ;

			// Setters
			void setRenderFlag (TEXTURE_RENDER_FLAG value) ;
			void setGammaCorrect (bool value) ;

		public :

			// Statics
			// Construction
			static TextureExternalData forDx11 (void* resource) ;
			static TextureExternalData forDx12 (void* resource, RESOURCE_STATE state) ;
			static TextureExternalData forGles (unsigned int id) ;

		private :

			// Functions
			// Constructor
			TextureExternalData (void* resource) noexcept ;
			TextureExternalData (void* resource, RESOURCE_STATE state) noexcept ;
			TextureExternalData (unsigned int id) noexcept ;

		private :

			// Attributes
			// Dx specifics
			void* _resource ;

			// Dx12 specifics
			RESOURCE_STATE _state ;

			// Gl specifics
			unsigned int _id ;

			// Globals
			TEXTURE_RENDER_FLAG _renderFlag ;
			RENDERING_API _targetApi ;
			bool _gammaCorrect ;
	} ;
}